/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class SerializingMessageConverter
implements HttpMessageConverter<Serializable> {
    public static final MediaType MEDIA_TYPE = new MediaType("application", "java-serialized-object");

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return Serializable.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MEDIA_TYPE);
    }

    public Serializable read(Class<? extends Serializable> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(inputMessage.getBody());
            Object object = ois.readObject();
            Serializable serializable = (Serializable)object;
            return serializable;
        }
        catch (ClassNotFoundException x) {
            throw new HttpMessageNotReadableException("Class not found: " + x.getMessage(), (Throwable)x, inputMessage);
        }
        catch (StreamCorruptedException x) {
            throw new HttpMessageNotReadableException("Cannot parse stream: " + inputMessage.getHeaders(), inputMessage);
        }
        finally {
            if (ois != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Serializable t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(outputMessage.getBody());
            oos.writeObject(t);
            oos.flush();
        }
        finally {
            if (oos != null) {
                // empty if block
            }
        }
    }
}

